function PlaylistItemAction(object, playlistItem) {
	this.unique_id = object.unique_id;
	this.name = "";
	this.position = 0;
	this.position_timecode = "00:00:00:00";
	this.position_type = "fromStart";
	this.parameter = "";
	this.is_valid = false;
	this.is_outpoint_clamped = false;
	this.is_inpoint_clamped = false;
	this.is_offline = false;
	
	this.parameters = {};
	this.action_template_unique_id = "";
	
	this.playlistItem = playlistItem;

	this.updateFrom = function(object) {
		if (object) {
			if (object.name != undefined)
				this.name = object.name;
			if (object.position != undefined)
				this.position = object.position;
			if (object.position_timecode != undefined)
				this.position_timecode = object.position_timecode;
			if (object.position_type != undefined)
				this.position_type = object.position_type;
			if (object.parameter != undefined)
				this.parameter = object.parameter;
			if (object.is_valid != undefined)
				this.is_valid = object.is_valid;
			if (object.is_outpoint_clamped != undefined)
				this.is_outpoint_clamped = object.is_outpoint_clamped;
			if (object.is_inpoint_clamped != undefined)
				this.is_inpoint_clamped = object.is_inpoint_clamped;
			if (object.is_offline != undefined)
				this.is_offline = object.is_offline;
			
			//v2
			if (object.parameters != undefined)
				this.parameters = object.parameters;
			if (object.action_template_unique_id != undefined)
				this.action_template_unique_id = object.action_template_unique_id;

		}
	}

	if (object) {
		this.updateFrom(object);
	}
	
	this.isValid = function() {
		return this.is_valid || this.isClamped();
	}

	this.isOffline = function() {
		return this.is_offline;
	}

	this.isEditable = function() {
		return this.playlistItem.isEditable();
	}

	this.isClamped = function() {
		return this.is_outpoint_clamped || this.is_inpoint_clamped;
	}

	this.isInvalid = function() {
		return this.isOffline() || !this.isValid();
	}

	/*
	 * Tanslate the actionName camelcased into human readable actionName
	 * Return String
	 */
	this.getRelativityDisplayString = function() {
			switch(this.position_type){
				case 'fromStart':
					return "Start"
					break;
				case 'fromInPoint':
					return "In point"
					break;
				case 'fromOutPoint':
					return "Out point"
					break;
				case 'fromEnd':
					return "End"
					break;
				case 'beforeStart':
					return "Before Start"
					break;
				default:
					return "&nbsp;"
					break;
			}
			return "&nbsp;";
	}

	this.getStatus = function() {

	}

	this.getTooltipMessage = function() {
		let result = "";
		
		if (this.isOffline()) {
			result = "This Action is offline, the specified AppleScript file linked to this action can not be found. Make sure it is in the 'Actions' folder.";
			return result;
		}

		if (this.isClamped()) {
			if (this.is_outpoint_clamped) {
				result = "This Action is set to be triggered juste after the out point of the clip (less than 1 second after). Therefore, we have 'clamped' it so it will be triggered at the end of the clip.";
			} else {
				result = "This Action is set to be triggered juste before the in point of the clip (less than 1 second before). Therefore, we have 'clamped' it so it will be triggered at the start of the clip.";
			}
		} else if (!this.isClamped() && this.isValid()) {
			result = "";
		} else {
			result = "This Action is set to be triggered at a time outside the current boundaries (before in or after out point), so it will not be triggered. Check both the time value and its the 'Relative to' attribute.";
		}

		return result;
	}

	this.getStatusIcon = function() {
		let result = "&#10004;";
		
		if (this.isOffline()) {
			return result;
		}

		if (this.isClamped()) {
			if (this.is_outpoint_clamped) {
				result = "&#8676;";
			} else {
				result = "&#8677;";
			}
		} else if (!this.isClamped() && this.isValid()) {
			result = "&#10004;";
		} else {
			result = "&#10006;";
		}

		return result;
	}

	this.getActionNameFilter = function() {
		//return escapeHTML(this.name).replace(/[\s_]/g, '');
	}

}
